package gov.va.med.mhv.sm.admin.data.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;

import org.springframework.stereotype.Component;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
//import com.google.gson.JsonDeserializationContext;
//import com.google.gson.JsonDeserializer;
//import com.google.gson.JsonElement;
//import com.google.gson.JsonParseException;

@Component
public class CustomDateSerializer extends JsonSerializer<Date> {

    public static String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private final SimpleDateFormat sdf = new SimpleDateFormat (RFC1123_PATTERN);

    @Override
    public void serialize(Date value, JsonGenerator gen, SerializerProvider arg2)  throws IOException, JsonProcessingException {

    	System.out.println("I AM HERE >>>>>>>>>>>>>>>>>>>>> " + value);
    	String dateString_RFC1123 = sdf.format(value);
        gen.writeString(dateString_RFC1123);
    }
}